package complex_operations;

import db_context.DbContext;
import db_context.MyExceptions;
import row_data_gateway.*;
import row_data_gateway.Package;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class FreeDriver {
    private static final FreeDriver INSTANCE = new FreeDriver();
    public static FreeDriver getInstance() {
        return INSTANCE;
    }
    private FreeDriver() {
    }

    public void FindFreeDriver() throws Exception {
        DbContext.getConnection().setTransactionIsolation(Connection.TRANSACTION_REPEATABLE_READ);
        DbContext.getConnection().setAutoCommit(false);
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            System.out.println("Enter transport id");

            SQLLock();
            Transport transport = TransportFinder.getInstance().findById(Integer.parseInt(br.readLine()));
            Package p = PackageFinder.getInstance().findById(transport.getPackage_id());
            if(!p.getStatus().equals("ready")) throw new MyExceptions.LogicException("This package is either new or already delivered");

            Driver driver = FreeDriver.getInstance().SQLQuery(transport.getStarting_loc_id());
            driver.setTransport_id(transport.getId());
            driver.update();
            System.out.println("transport was added to driver with id: " + driver.getId());

            DbContext.getConnection().commit();
        }catch (Exception e){
            if(e.getClass().toString().substring(0,29).equals("class db_context.MyExceptions")) throw e;
            else if(e.getClass().toString().equals("class org.postgresql.util.PSQLException")) System.out.println("This transport already has driver");
            else System.out.println("Cannot find free driver");

            DbContext.getConnection().rollback();
        }finally {
            DbContext.getConnection().setAutoCommit(true);
        }
    }

    public void SQLLock() throws SQLException {
        try(PreparedStatement s = DbContext.getConnection().prepareStatement("lock drivers in access exclusive mode")){
            s.execute();
        }
    }

    public Driver SQLQuery(int loc_id) throws SQLException, MyExceptions.NotSuchIdException {
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT * FROM drivers WHERE location_id = ? and transport_id is null;")){
            s.setInt(1, loc_id);
            try (ResultSet r = s.executeQuery()) {
                if (r.next()) {
                    Driver d = DriverFinder.getInstance().SetDriver(r);

                    if(d.getTransport_id() == 0) d.setTransport_id(null);
                    return d;
                } else {
                    throw new MyExceptions.NotSuchIdException("Cannot find free driver in this location");
                }
            }
        }
    }
}
